### Name: NetCDFPeakFinding
### Title: Peak picking algorithm from CDF files
### Aliases: NetCDFPeakFinding


### ** Examples

require(TargetSearchData)
data(TargetSearchData)
CDFpath <- file.path(.find.package("TargetSearchData"), "gc-ms-data")
CDFfiles <- dir(CDFpath, pattern = "\.cdf$", full.names = TRUE)
CDFfiles

# extrac peaks of first chromatogram
peaks.1 <- NetCDFPeakFinding(CDFfiles[1], massRange = c(85, 320), Window = 15,
                         IntThreshold = 10, pp.method = "smoothing")
# scan acquisition times
head(peaks.1$Time)
# peaks in matrix form. first column is mass 85, last one is mass 320.
head(peaks.1$Peaks)




