### Name: spia
### Title: Signaling Pathway Impact Analysis (SPIA) based on
###   over-representation and signaling perturbations accumulation
### Aliases: spia
### Keywords: nonparametric methods

### ** Examples

# Example using a colorectal cancer dataset obtained using Affymetrix geneChip technology (GEO GSE4107).
# Suppose that proper preprocessing was performed and a two group moderated t-test was applied. The topTable 
# result from limma package for this data set is called "top".
#The following lines will annotate each probeset to an entrez ID identifier, will keep the most significant probeset for each 
#gene ID and retain those with FDR<0.05 as differentially expressed.
#You can run these lines if hgu133plus2.db package is available

#data(colorectalcancer)
#x <- hgu133plus2ENTREZID 
#top$ENTREZ<-unlist(as.list(x[top$ID]))
#top<-top[!is.na(top$ENTREZ),]
#top<-top[!duplicated(top$ENTREZ),]
#tg1<-top[top$adj.P.Val<0.05,]
#DE_Colorectal=tg1$logFC
#names(DE_Colorectal)<-as.vector(tg1$ENTREZ)
#ALL_Colorectal=top$ENTREZ

data(colorectalcancer)

# pathway analysis using SPIA; # use nB=2000 or higher for more accurate results
res<-spia(de=DE_Colorectal, all=ALL_Colorectal, organism="hsa",beta=NULL,nB=200,plots=FALSE, verbose=TRUE)
res
# Create the evidence plot
plotP(res)




