### Name: seqMatcherAlign
### Title: Functions to do local alignment of two sequences using EMBOSS
###   matcher
### Aliases: seqMatcherAlign getAlignStats
### Keywords: methods

### ** Examples


seq1 <- "RPHEDEKEAIDEAKKMKVPGENEDESKEEEKSQELEEAIDSKEKSTDARDEQGDEGDNEEENNEEDNENENEHTAPPALVMPSPIEMEEQRM"
seq2 <- "QKYLLKKAIRNFSEYPFYAQNKLIHQQATGLILTEEEKSQELEEKIISKIKKEEHLKKINLKHDYFDLQKKYEKECEILTKLSENLRKEK"
seq3 <- "IHQQATGLILTKIISKIKKEEHVPGENEDLKKINLKHDYFDLQKKYEKECEILTKLSENLRKEEIENKRKEHELMEQKRREEGIETEKEKSLRHPSSSSSSRRRN"
seqBank <- list(seq1=list(seq=seq1),seq2=list(seq=seq2),seq3=list(seq=seq3))
bid <- names(seqBank)
pnames <- c("seq1","seq3")
## Not run: 
##D ar <- seqMatcherAlign(pnames, bid, seqBank)
##D ar
##D getAlignStats(ar)
## End(Not run)



