### Name: gps-methods
### Title: Methods for predicting the GPS of given dataset by using a given
###   mutagenetic trees mixture model
### Aliases: gps gps-methods gps,RtreemixModel,RtreemixData-method
###   gps,RtreemixModel,matrix-method gps,RtreemixModel,missing-method
### Keywords: methods survival

### ** Examples

## Create an RtreemixData object from a randomly generated RtreemixModel object.
#rand.mod <- generate(K = 2, no.events = 7, noise.tree = TRUE, prob = c(0.2, 0.8))
#data <- sim(model = rand.mod, no.draws = 400)

## Create an RtreemixModel object by fitting model to the given data.
#mod <- fit(data = data, K = 2, equal.edgeweights = TRUE, noise = TRUE)
#show(mod)

## Create an RtreemixGPS object by calculating the GPS for all possible patterns.
#modGPS.all <- gps(model = mod, no.sim = 1000) ## time consuming copmutations
#show(modGPS.all)

## See the GPS values for all possible data.
#GPS(modGPS.all) ## time consuming copmutations

## Create an RtreemixGPS object by calculating the GPS for the data based on the model mod.
#modGPS <- gps(model = mod, data = data, no.sim = 1000)
#show(modGPS) ## time consuming copmutations

## See the GPS values for data.
#GPS(modGPS) ## time consuming copmutations



