### Name: graphConverter
### Title: maps one type of grap onto another
### Aliases: graphConverter hyperGraphConverter
### Keywords: manip

### ** Examples


  ##Set up a graphNEL object to convert
  library(RpsiXML)  
  directory <- system.file("/extdata/psi25files",
                           package="RpsiXML")
  mintXML <- file.path(directory, 
                       "mint_200711_test.xml")
  mintGraph <- separateXMLDataByExpt(xmlFiles=mintXML, 
                                     psimi25source = MINT.PSIMI25, 
                                     type = "indirect", 
                                     directed=TRUE, 
                                     abstract=FALSE)

  if(require("hom.Mm.inp.db")) {
    ##convert it
    newGraph = graphConverter(mintGraph[[1]], "MUSMU", "HOMSA")
  }

  ##Get a hypergraph
  xmlDir <- system.file("/extdata/psi25files",package="RpsiXML")
  intactComplexxml <- file.path(xmlDir,"intact_complexSample.xml")
  hyperGraph <- buildPCHypergraph(intactComplexxml, INTACT.PSIMI25)

  if(require("hom.Hs.inp.db")) {
  ##Convert it
  newHyper = hyperGraphConverter(hyperGraph, "HOMSA", "MUSMU", "UNIPROT",
  "UNIPROT")
  }

  ##Get a incidence matrix from ScISI
  if(require(ScISI)) {
    data(ScISIC)

    if(require("org.Sc.eg.db")) {
    ##Convert it
    newScISIC = hyperGraphConverter(ScISIC, "SACCE", "MUSMU",
    srcIDType="ORF", destIDType = "EG")
  }
  }



