### Name: plotErrorsRepeatedOneLayerCV-methods
### Title: plotErrorsRepeatedOneLayerCV Method to plot the estimated error
###   rates in each repeat of a one-layer Cross-validation
### Aliases: plotErrorsRepeatedOneLayerCV
###   plotErrorsRepeatedOneLayerCV-methods
###   plotErrorsRepeatedOneLayerCV,assessment-method
### Keywords: methods

### ** Examples

data('vV70genesDataset')

expeOfInterest <- new("assessment", dataset=vV70genes,
                                   noFolds1stLayer=3,
                                   noFolds2ndLayer=2,
                                   classifierName="svm",
                                   typeFoldCreation="original",
                                   svmKernel="linear",
                                   noOfRepeat=10,
                                   featureSelectionOptions=new("geneSubsets", optionValues=c(1,2,3,4,5,6)))

expeOfInterest <- runOneLayerExtCV(expeOfInterest)

plotErrorsRepeatedOneLayerCV(expeOfInterest)




