### Name: geneSubsets-class
### Title: geneSubsets: A class to handle the sizes of gene susbets to be
###   tested during forward gene selection
### Aliases: geneSubsets-class getMaxSubsetSize,geneSubsets-method
###   getMaxSubsetSize<-,geneSubsets-method getMaxSubsetSize
###   getMaxSubsetSize<- getNoModels,geneSubsets-method getNoModels
###   getSpeed,geneSubsets-method getSpeed<-,geneSubsets-method getSpeed
###   getSpeed<- getSubsetsSizes,geneSubsets-method
###   getSubsetsSizes<-,geneSubsets-method getSubsetsSizes
###   getSubsetsSizes<-
### Keywords: classes

### ** Examples

geneSubset235 <- new("geneSubsets", optionValues=c(2,3,5))
geneSubset235
getSubsetsSizes(geneSubset235)
getSpeed(geneSubset235)
getMaxSubsetSize(geneSubset235)

geneSubsetMax60 <- new("geneSubsets", maxSubsetSize=60, speed="slow")
geneSubsetMax60

geneSubsetSlow <- new("geneSubsets", maxSubsetSize=70, speed="slow")
geneSubsetSlow

getMaxSubsetSize(geneSubsetMax60) <- 70
geneSubsetMax60

newSizes <- c(1,2,3,4,5)
getSubsetsSizes(geneSubsetMax60) <- newSizes
geneSubsetMax60

getSpeed(geneSubset235) <- 'slow'
geneSubset235



