### Name: classifyNewSamples-methods
### Title: classifyNewSamples Method to classify new samples for a given
###   assessment
### Aliases: classifyNewSamples classifyNewSamples-methods
###   classifyNewSamples,assessment-method
### Keywords: methods

### ** Examples


data('vV70genesDataset')

expeOfInterest <- new("assessment", dataset=vV70genes,
                                   noFolds1stLayer=10,
                                   noFolds2ndLayer=9,
                                   classifierName="svm",
                                   typeFoldCreation="original",
                                   svmKernel="linear",
                                   noOfRepeat=2,
                                   featureSelectionOptions=new("geneSubsets", optionValues=c(1,2,4,8,16,32,64,70)))

# Build the final classifier
expeOfInterest <- findFinalClassifier(expeOfInterest)

## Not run: 
##D classifyNewSamples(expeOfInterest, "pathToFile/testSamples_geneExpr.txt", 4)
## End(Not run)
expeOfInterest <- runOneLayerExtCV(expeOfInterest)
## Not run: 
##D classifyNewSamples(expeOfInterest, "pathToFile/testSamples_geneExpr.txt")
## End(Not run)



