### Name: cher-class
### Title: Class "cher" - ChIP-enriched region
### Aliases: cher-class initialize,cher-method show,cher-method
###   update,cher-method cher Cher cherList cherList-class
###   cellType<-,cher,character-method cellType,cher-method cellType
###   cellType<-
### Keywords: classes

### ** Examples

  ## how to create a cher object from scratch
  cherNudt2 <- new("cher", name="nudt2.cher", chromosome=9,
                   start=34318954, end=34319944, antibody="Suz12",
                   maxLevel=2.00, score=69.2, upSymbol="NUDT2")
                   #extras=list(upSymbol="NUDT2"))
  cherNudt2
  str(cherNudt2)

  ## use the update method (note:this update is biologically meaningless)
  cher2 <- update(cherNudt2, cellType="HeLa", downSymbol="P53",
                  probes=c("probe1","probe2"))
  cher2; str(cher2)

  ## plot a cher object
  exDir <- system.file("exData",package="Ringo")
  load(file.path(exDir,"exampleProbeAnno.rda"))
  load(file.path(exDir,"exampleX.rda"))
  smoothX <- computeRunningMedians(exampleX, probeAnno=exProbeAnno,
       modColumn = "Cy5", allChr = "9", winHalfSize = 400)
  plot(cherNudt2, smoothX, probeAnno=exProbeAnno, gff=exGFF, extent=5000)



