###################################################
### chunk number 1:  eval=FALSE
###################################################
## apt.rma.sk <- read.delim("rma-bg.quant-norm.pm-only.med-polish.summary.txt", row.names=1, comment.char="", skip=50)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## apt.rma <- read.delim("rma-bg.quant-norm.pm-only.med-polish.summary.txt", row.names=1, comment.char="", skip=50)


###################################################
### chunk number 3:  eval=FALSE
###################################################
## plot(log2(apt.rma[,1] * apt.rma.sk[,1])/2, log2(apt.rma.sk[,1]/apt.rma[,1]), main="APT: RMA vs RMA-sketch", xlab="A = Log2(SketchRMA*RMA)", ylab="M = Log2(SketchRMA/RMA)",log="",ylim=c(-0.1,0.1))


###################################################
### chunk number 4:  eval=FALSE
###################################################
## data.rma <- rma(data.u133p2, "MixU133P2RMA", background="pmonly", normalize=TRUE)
## xps.rma  <- validData(data.rma)


###################################################
### chunk number 5:  eval=FALSE
###################################################
## plot(log2(apt.rma[,1] * xps.rma[,1])/2, log2(xps.rma[,1]/apt.rma[,1]), main="RMA: XPS vs APT", xlab="A = Log2(XPS*APT)", ylab="M = Log2(XPS/APT)",log="",ylim=c(-0.1,0.1))


###################################################
### chunk number 6:  eval=FALSE
###################################################
## affy.rma <- justRMA()
## affy.rma <- 2^exprs(affy.rma)


###################################################
### chunk number 7:  eval=FALSE
###################################################
## tmp <- cbind(xps.rma[,1],affy.rma[,1],apt.rma[,1])
## colnames(tmp) <- c("xps.rma","affy.rma","apt.rma")
## pairs(log2(tmp), labels=colnames(tmp))


###################################################
### chunk number 8:  eval=FALSE
###################################################
## apt.mas5 <- read.delim("mas5-bg.pm-mm.mas5-signal.summary.txt", row.names=1, comment.char="", skip=50)
## apt.mas5 <- apply(apt.mas5, 2, function(x){x*(500/mean(x, trim=0.02))})


###################################################
### chunk number 9:  eval=FALSE
###################################################
## data.mas5 <- mas5(data.u133p2,"MixU133P2MAS5All", normalize=TRUE, sc=500, update=TRUE)
## xps.mas5 <- validData(data.mas5)


###################################################
### chunk number 10:  eval=FALSE
###################################################
## affy <- ReadAffy()
## affy.mas5 <- mas5(affy, normalize=TRUE, sc=500)
## affy.mas5 <- exprs(affy.mas5)


###################################################
### chunk number 11:  eval=FALSE
###################################################
## call.mas5 <- mas5.call(data.u133p2,"MixU133P2Call")
## xps.pval  <- pvalData(call.mas5)


###################################################
### chunk number 12:  eval=FALSE
###################################################
## affy <- ReadAffy()
## affy.dc5  <- mas5calls(affy)
## affy.pval <- assayData(affy.dc5)[["se.exprs"]]


###################################################
### chunk number 13:  eval=FALSE
###################################################
## data.g.rma <- rma(data.genome, "HuGeneMixRMAMetacore", background="antigenomic", normalize=T,
##                   exonlevel="metacore+affx")
## xps.rma  <- validData(data.g.rma)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## tmp <- as.data.frame(rownames(xps.rma))
## colnames(tmp) <- "probeset_id"
## write.table(tmp, "probesetList.txt", quote=FALSE, row.names=FALSE)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## expr.mp <- express(data.genome,"HuGeneMixMedPolMetacore",summarize.method="medianpolish",
##            summarize.select="pmonly",summarize.option="transcript",summarize.logbase="log2",
##            summarize.params=c(10, 0.01, 1.0),exonlevel="metacore+affx")
## xps.mp <- validData(expr.mp)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## data.rma.bq16 <- rma(data.genome, "HuGeneMixRMAbgqu16mp8", background="antigenomic",
##                      normalize=T, exonlevel=c(16316,16316,8252))
## xps.rma.bq16  <- validData(data.rma.bq16)


###################################################
### chunk number 17:  eval=FALSE
###################################################
## call.g.dabg <- dabg.call(data.genome, "HuGeneMixDABGMetacore", exonlevel="metacore+affx")
## xps.pval <- pvalData(call.g.dabg)


###################################################
### chunk number 18:  eval=FALSE
###################################################
## call.g.mas5 <- mas5.call(data.genome, "HuGeneMixCallMetacore", exonlevel="metacore+affx")
## mas.pval <- pvalData(call.g.mas5)


###################################################
### chunk number 19:  eval=FALSE
###################################################
## data.x.rma.ps <- rma(data.exon,"MixRMAMetacorePS", background="antigenomic",
##                      normalize=T, option="probeset", exonlevel="metacore")
## xps.rma.ps <- validData(data.x.rma.ps)


###################################################
### chunk number 20:  eval=FALSE
###################################################
## tmp <- as.data.frame(rownames(xps.rma.ps))
## colnames(tmp) <- "probeset_id"
## write.table(tmp, "metacorePSList.txt", quote=FALSE, row.names=FALSE)


###################################################
### chunk number 21:  eval=FALSE
###################################################
## expr.mp.ps <- express(data.exon, "HuExonMixMedPolMetacore", summarize.method="medianpolish",
##               summarize.select="pmonly", summarize.option="probeset", summarize.logbase="log2",
##               summarize.params=c(10, 0.01, 1.0), exonlevel="metacore")
## xps.mp.ps <- validData(expr.mp.ps)


###################################################
### chunk number 22:  eval=FALSE
###################################################
## data.rma.ps.bq16 <- rma(data.exon, "HuExonMixRMAbgqu16mp8", background="antigenomic", 
##                     normalize=T, option="probeset", exonlevel=c(16316,16316,8192))
## xps.rma.ps.bq16 <- validData(data.rma.ps.bq16)


###################################################
### chunk number 23:  eval=FALSE
###################################################
## data.x.rma <- rma(data.exon, "MixRMAMetacore", background="antigenomic",
##                   normalize=T, option="transcript", exonlevel="metacore")
## xps.rma  <- validData(data.x.rma)


###################################################
### chunk number 24:  eval=FALSE
###################################################
## writeLines(rownames(xps.rma), "metacore.txt")
## metaProbesets(scheme.exon, "metacore.txt", "metacoreList.mps", exonlevel="metacore")


###################################################
### chunk number 25:  eval=FALSE
###################################################
## expr.mp <- express(data.exon,"HuExonMedPolMetacore",summarize.method="medianpolish",
##            summarize.select="pmonly",summarize.option="transcript",summarize.logbase="log2",
##            summarize.params=c(10, 0.01, 1.0),exonlevel="metacore")
## xps.mp <- validData(expr.mp)


###################################################
### chunk number 26:  eval=FALSE
###################################################
## data.rma.ps.bq16 <- rma(data.exon, "HuExonMixRMAbgqu16mp8", background="antigenomic", 
##                     normalize=T, option="probeset", exonlevel=c(16316,16316,8192))
## xps.rma.ps.bq16 <- validData(data.rma.ps.bq16)


###################################################
### chunk number 27:  eval=FALSE
###################################################
## call.x.dabg.ps <- dabg.call(data.exon, "MixDABGMetacorePS", option="probeset", exonlevel="metacore")
## xps.pval.ps <- pvalData(call.x.dabg.ps)


###################################################
### chunk number 28:  eval=FALSE
###################################################
## call.x.dabg <- dabg.call(data.exon, "MixDABGMetacore", option="transcript", exonlevel="metacore")
## xps.pval <- pvalData(call.x.dabg)


###################################################
### chunk number 29:  eval=FALSE
###################################################
## hx2hg <- read.delim("HuExVsHuGene_BestMatch.txt", row.names=3)
## up2hx <- read.delim("U133PlusVsHuEx_BestMatch.txt", row.names=3)
## up2hg <- read.delim("U133PlusVsHuGene_BestMatch.txt", row.names=3)


###################################################
### chunk number 30:  eval=FALSE
###################################################
## hx2hg <- uniqueframe(hx2hg)
## up2hx <- uniqueframe(up2hx)
## up2hg <- uniqueframe(up2hg)
## u2x   <- intersectframes(up2hx, up2hg)
## u2g   <- intersectframes(up2hg, up2hx)
## tmp   <- intersectrows(u2gx, xps.grma, 1, NULL)
## meta  <- intersectrows(tmp,  xps.xrma, 2, NULL)


###################################################
### chunk number 31:  eval=FALSE
###################################################
## xpsu <- intersectrows(xps.urma, meta, NULL, NULL)
## xpsg <- intersectrows(xps.grma, meta, NULL, 1, -1)
## xpsx <- intersectrows(xps.xrma, meta, NULL, 2, -1)
## aptg <- intersectrows(apt.grma, meta, NULL, 1, -1)
## aptx <- intersectrows(apt.xrma, meta, NULL, 2, -1)


###################################################
### chunk number 32:  eval=FALSE
###################################################
## tissue <- c(rep("Breast", 3), rep("Prostate", 3))
## design <- model.matrix(~factor(tissue)) 
## colnames(design) <- c("Breast","BreastvsProstate") 


###################################################
### chunk number 33:  eval=FALSE
###################################################
## tmp <- as.matrix(log2(xpsu))
## fit <- lmFit(tmp, design) 
## fit <- eBayes(fit) 
## xpsu.lm <- topTable(fit, coef=2, n=length(rownames(tmp)), adjust="BH")


###################################################
### chunk number 34:  eval=FALSE
###################################################
## apt.plier <- read.delim("plier-mm.summary.txt", row.names=1, comment.char="", skip=50)


###################################################
### chunk number 35:  eval=FALSE
###################################################
## plot(apt.plier[,1], apt.plier[,2], main="APT: PLIER", xlab="Breast_A", ylab="Breast_B",log="xy")


###################################################
### chunk number 36:  eval=FALSE
###################################################
## plot(log2(apt.plier[,1] * apt.plier[,2])/2, log2(apt.plier[,1]/apt.plier[,2]), main="APT: PLIER", xlab="A = Log2(BrA*BrB)", ylab="M = Log2(BrA/BrB)",log="")
## plot(log2(apt.rma[,1] * apt.rma[,2])/2, log2(apt.rma[,1]/apt.rma[,2]), main="APT: RMA", xlab="A = Log2(BrA*BrB)", ylab="M = Log2(BrA/BrB)",log="",ylim=c(-10,10))


