### Name: xmap.files
### Title: Underlying xmap methods for manipulating projects, graphs, and
###   plots
### Aliases: xmap.debug xmap.project.new xmap.project.list
###   xmap.project.load xmap.project.save xmap.project.delete
###   xmap.graph.new xmap.graph.list xmap.graph.load xmap.graph.save
###   xmap.graph.delete xmap.plot.new xmap.plot.list xmap.plot.load
###   xmap.plot.save xmap.plot.delete ==,Graph,Graph-method
###   ==,Plot,Plot-method ==,Project,Project-method !=,Graph,Graph-method
###   !=,Plot,Plot-method !=,Project,Project-method
###   as.character,Graph-method as.character,Plot-method
###   as.character,Project-method


### ** Examples

  ## Don't show: 
    path     <- tempdir()
    old.path <- Sys.getenv( "XMAP_BRIDGE_CACHE" )
    Sys.setenv( XMAP_BRIDGE_CACHE=path )
  
## End Don't show
  # Create a new project
  projectid <- xmap.project.new( "A quick project" )

  # Create a graph in this project covering 100K bases on chromosome 1
  graphid <- xmap.graph.new( projectid, "A quick graph", "This is a quick graph", 
                            -10, 10, "1", 5000, 105000, species="homo_sapiens" )

  # Make our datasets
  x <- seq( 1000, 100000, by = 1000 )
  y <- runif( length( x ), -10, 10 )

  # Then add a plot to this graph
  xmap.plot.new( graphid, "Graph 1", x, y, type="area", col=0xAAFFEE00 )

  # And another one, in a different colour  
  a <- xmap.plot.new( graphid, "Graph 2", x, y, type="scatter", col=0xAA0000FF )
  
  cat( xmap.debug( a, newlines=TRUE ) )

  # At this point, we should be able to see the graphs using the XMapBridge application

  # Clean up our project file...
  xmap.project.delete( projectid )
  ## Don't show: 
    Sys.setenv( XMAP_BRIDGE_CACHE=old.path )
  
## End Don't show



