###################################################
### chunk number 1:  eval=FALSE
###################################################
## q(save="no")
## 


###################################################
### chunk number 2: 
###################################################
library(splines)
library(stats)
library(golubEsets)
library(vsn)
oldopt <- options(digits=3)
on.exit( {options(oldopt)} )
options(width=75)


###################################################
### chunk number 3: 
###################################################
data(Golub_Train)
golubNorm <- justvsn(Golub_Train)
id <- as.numeric(Golub_Train$ALL.AML) #$


###################################################
### chunk number 4: 
###################################################
Golub_Train$ALL.AML #$
id


###################################################
### chunk number 5: 
###################################################
library(twilight)
pval <- twilight.pval(golubNorm, id, B=100)


###################################################
### chunk number 6: 
###################################################
data(expval)
expval


###################################################
### chunk number 7: 
###################################################
class(expval)
names(expval)


###################################################
### chunk number 8: 
###################################################
names(expval$result) #$


###################################################
### chunk number 9: 
###################################################
expval$result[1:7,1:5] #$


###################################################
### chunk number 10: 
###################################################
bitmap(file="tr_2004_01-scores.png",width=6,height=4.5,pointsize=10)
plot(expval,which="scores",grayscale=F,legend=F)
dev.off()
bitmap(file="tr_2004_01-qvalues.png",width=6,height=4.5,pointsize=10)
plot(expval,which="qvalues")
dev.off()


###################################################
### chunk number 11: 
###################################################
expval$pi0 #$


###################################################
### chunk number 12: 
###################################################
gene <- exprs(golubNorm)[pval$result$index[1],]
corr <- twilight.pval(golubNorm,gene,method="spearman",quant.ci=0.99,B=100)
corr


###################################################
### chunk number 13: 
###################################################
corr$result[1:10,1:5] #$


###################################################
### chunk number 14: 
###################################################
bitmap(file="tr_2004_01-corr.png",width=6,height=4.5,pointsize=10)
plot(corr,which="scores",grayscale=F,legend=F)
dev.off()


###################################################
### chunk number 15: 
###################################################
yperm <- twilight.filtering(golubNorm,id,method="fc",num.perm=50,num.take=10)
dim(yperm)


###################################################
### chunk number 16: 
###################################################
yperm <- yperm[-1,]
b <- twilight.pval(golubNorm,yperm[1,],method="fc",yperm=yperm)
hist(b$result$pvalue,col="gray",br=20)


###################################################
### chunk number 17: 
###################################################
bitmap(file="tr_2004_01-hist.png",width=6,height=4.5,pointsize=10)
hist(b$result$pvalue,col="gray",br=20,main="",xlab="P-value")
dev.off()


###################################################
### chunk number 18: 
###################################################
data(exfdr)
exfdr



###################################################
### chunk number 19: 
###################################################
exfdr$result[1:5,6:9] #$


###################################################
### chunk number 20: 
###################################################
bitmap(file="tr_2004_01-fdr.png",width=6,height=4.5,pointsize=10)
plot(exfdr,which="fdr",grayscale=F,legend=T)
dev.off()
bitmap(file="tr_2004_01-volcano.png",width=6,height=4.5,pointsize=10)
plot(exfdr,which="volcano")
dev.off()
bitmap(file="tr_2004_01-effectsize.png",width=6,height=4.5,pointsize=10)
plot(exfdr,which="effectsize",legend=T)
dev.off()


###################################################
### chunk number 21: 
###################################################
tab <- plot(exfdr,which="table")
tab[1:8,]


###################################################
### chunk number 22: 
###################################################
x <- c(rep(0,2),rep(1,3))
x


###################################################
### chunk number 23: 
###################################################
twilight.combi(x,pin=FALSE,bin=FALSE)


###################################################
### chunk number 24: 
###################################################
twilight.combi(x,pin=FALSE,bin=TRUE)


###################################################
### chunk number 25: 
###################################################
y <- c(rep(0,4),rep(1,4))
y


###################################################
### chunk number 26: 
###################################################
twilight.combi(y,pin=TRUE,bin=FALSE)


###################################################
### chunk number 27: 
###################################################
twilight.combi(y,pin=TRUE,bin=TRUE)


###################################################
### chunk number 28: 
###################################################
twilight.permute.pair(y,7,bal=TRUE)


###################################################
### chunk number 29: 
###################################################
Sys.sleep(30)


