###################################################
### chunk number 1: family-data
###################################################
require(snpMatrix)
data(families)
head(genotypes)
head(pedfile)


###################################################
### chunk number 2: mis-inheritances
###################################################
mis <- misinherits(data=pedfile, snp.data=genotypes)
dim(mis)


###################################################
### chunk number 3: per-subj-snp
###################################################
per.subj <- apply(mis, 1, sum, na.rm=TRUE)
per.snp <- apply(mis, 2, sum, na.rm=TRUE)
par(mfrow = c(1, 2))
hist(per.subj)
hist(per.snp)


###################################################
### chunk number 5: per-family
###################################################
fam <- pedfile[rownames(mis), "familyid"]
per.fam <- tapply(per.subj, fam, sum)
par(mfrow = c(1, 1))
hist(per.fam)


###################################################
### chunk number 6: tdt-tests
###################################################
tests <- tdt.snp(data=pedfile, snp.data=genotypes)
cbind(p.value(tests, 1), p.value(tests,2))
qq.chisq(chi.squared(tests, 1), df=1)


