### Name: runSigPathway
### Title: Perform pathway analysis
### Aliases: runSigPathway
### Keywords: array htest

### ** Examples

## Load in filtered, expression data
data(MuscleExample)

## Prepare the pathways to analyze and run analysis with 1 wrapper function

nsim <- 1000
ngroups <- 2
verbose <- TRUE
weightType <- "constant"
npath <- 25
allpathways <- FALSE
annotpkg <- "hgu133a.db"

res.muscle <- runSigPathway(G, 20, 500, tab, phenotype, nsim,
                            weightType, ngroups, npath, verbose,
                            allpathways, annotpkg)

## Summarize results
print(res.muscle$df.pathways)

## Get more information about the probe sets' means and other statistics
## for the top pathway in res.pathways
print(res.muscle$list.gPS[[1]])

## Write table of top-ranked pathways and their associated probe sets to
## HTML files
writeSigPathway(res.muscle, tempdir(), "sigPathway_rSP",
                "TopPathwaysTable.html")




