### Name: plotdensity.FCS
### Title: Create density plots one parameter of one (or more) FCS
###   object(s)
### Aliases: plotdensity.FCS densityplot.FCS
### Keywords: hplot

### ** Examples


 if (require(rfcdmin)) {
  ##Obtain the location of the fcs files 
  pathFiles<-system.file("bccrc", package="rfcdmin")
  drugFiles<-dir(pathFiles)

  ## Read a serie of FCS files
  drugData<-read.series.FCS(drugFiles,path=pathFiles,MY.DEBUG=FALSE)

  }

 ##Draw a density plot for the Foward SCatter parameter for the
 ##differents aliquots (of the same cell line) tested with different
 ##compounds.
 plotdensity.FCS(drugData,varpos=c(1),main="FSC for the aliquots treated
with different compounds", ylim=c(0,0.005), ylab="Density of cells")



