### Name: extractGatedData
### Title: Extract the data of a FCS object using a specified Gating Index
### Aliases: extractGatedData
### Keywords: data manip

### ** Examples

 if (require(rfcdmin)) {
      data.there<-is.element("MC.053",objects())
      if ((sum(data.there) != length(data.there))) {
        ## obtaining the FCS objects from VRC data
        data(MC.053min)
      }
  
####  test1 : Gating type: uniscut, univariate single cut
test1 <- createGate(MC.053, varpos=1, gatingrange=256,
                    type="uniscut", MY.DEBUG=TRUE)

#### test2.3 : Gating type : biscut -/-
test2.3 <- createGate(test1, varpos=c(1,2),
                      gatingrange=c(256, 300),
                      type="biscut",
                      biscut.quadrant="-/-",
                      prev.gateNum=NULL,
                      MY.DEBUG=TRUE)

### test 2.3.1 : extraction
test2.3.1 <- extractGatedData(test2.3, gateNum=2,
                              IndexValue.In=1,
                              MY.DEBUG=TRUE)
}



