### Name: gate-class
### Title: 'gate': a class for subsetting flow-cytometry data by defining
###   regions in two-dimesional projections of the data
### Aliases: gate-class gate applyGate,matrix,gate-method
###   appendGates,gateSet-method show,gate-method names,gate-method gate<-
###   drawGate combineGates as.gateSet as.gateSet,gate-method
###   names<-,gate-method lines,gate-method
### Keywords: classes

### ** Examples

sampdat <- readFCS(system.file("extdata", "fas-Bcl2-plate323-04-04.A01",
                               package="prada"))
g1 <- new("gate", name="test1", gateFun=function(x)x[,"FSC-H"]<500, logic="&",
          colnames="FSC-H", type="misc")
g1
g2 <- new("gate", name="test2", gateFun=function(x)x[,"SSC-H"]>800, logic="&",
          colnames="SSC-H", type="misc")
gs1 <- combineGates(g1,g2)
gs2 <- as.gateSet(g2)
names(g1)
names(g1) <- "testName"
applyGate(sampdat, g1)
applyGate(exprs(sampdat), g2)
gate(sampdat) <- g1
applyGate(sampdat, 1)
applyGate(sampdat, "testName")
applyGate(sampdat, TRUE)



