### Name: nem
### Title: Nested Effects Models - main function
### Aliases: nem print.nem
### Keywords: graphs models

### ** Examples

   data("BoutrosRNAi2002")
   D <- BoutrosRNAiDiscrete[,9:16]
   p <- c(.13,.05)
   res1 <- nem(D,para=p,inference="search")
   res2 <- nem(D,para=p,inference="pairwise")
   res3 <- nem(D,para=p,inference="triples")
   res4 <- nem(D,para=p,inference="ModuleNetwork")
   res5 <- nem(D,para=p,inference="nem.greedy")  
   res6 = nem(BoutrosRNAiLods, inference="nem.greedyMAP")
   

   par(mfrow=c(2,3))
   plot(res1,main="exhaustive search")
   plot(res2,main="pairs")
   plot(res3,main="triples")
   plot(res4,main="module network")
   plot(res5,main="greedy hillclimber")      
   plot(res6,main="alternating MAP optimization")



