### Name: loadmirnapathways
### Title: Load gene to pathway associations for miRNApath
### Aliases: loadmirnapathways
### Keywords: IO manip attribute

### ** Examples


## Load miRNA expression data from AD miRNA paper
## This data contains miRNA expression data, 
data(mirnaobj);

## Write a file as example of required input
write.table(mirnaobj@mirnaPathways, file = "mirnaPathways.txt", 
    quote = FALSE, row.names = FALSE, col.names = TRUE, na = "",
    sep = "\t");

## Load the gene to pathway associations
mirnaobj <- loadmirnapathways( mirnaobj = mirnaobj, 
    pathwayfile = "mirnaPathways.txt", 
    pathwaycol = "Pathway Name", genecol = "Entrez Gene ID");

## Display summary, noting the number of genes reported
mirnaobj;



