### Name: fitmaanova
### Title: Fit ANOVA model for Micro Array experiment
### Aliases: fitmaanova
### Keywords: models

### ** Examples

###################################
# fixed model fitting
###################################
# load in abf1 data
data(abf1)
## Not run: 
##D 
##D # fit model with random effect
##D fit.full.mix <- fitmaanova(abf1, formula = ~Strain+Sample, 
##D    random = ~Sample)
##D 
##D # this is to explain the usage of including covariate variable.
##D # .CEL file is not included in the package, thus use can not use this. 
##D # array specific covariate : add it to the design matrix 
##D beforeRma <- ReadAffy() # suppose there are 18 arrays.
##D rmaData <- rma(beforeRma)
##D datafile <- exprs(rmaData)
##D design.table=data.frame(Array=row.names(pData(beforeRma)))
##D Strain = rep(c('Aj', 'B6', 'B6xAJ'), each=6) 
##D Sample = rep(c(1:9), each=2) 
##D Cov1 = sample(1:100,18) # this is artificial example 
##D designfile.cov1 = cbind(design.table, Strain, Sample,Cov1) 
##D data.cov1=read.madata(datafile, designfile=designfile.cov1) 
##D fit.cov1 = fitmaanova(data.cov1,formula = ~Strain+Sample+Cov1, covariate = ~ Cov1) 
##D 
##D # gene specific covariate - make artificial 'covM' matrix 
##D covm = matrix(rnorm(length(datafile)), nrow=nrow(datafile)) 
##D designfile.cov2 = cbind(design.table, Strain, Sample) 
##D data.cov2=read.madata(datafile, designfile=designfile.cov2, covM=covm) 
##D fit.cov2 = fitmaanova(data.cov2,formula = ~Strain+Sample+covM, covariate = ~ covM) 
## End(Not run)



