/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.boss;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.systemsbiology.gaggle.util.TextFileReader;
import org.systemsbiology.gaggle.util.TextJarReader;

public class BossConfig {
    String argSpecificationString = "p:n:";
    String[] commandLineArguments;
    String[] commandLineArgumentsCopy;
    String propsFilename;
    String nameHelperUri = null;
    File projectFileDirectoryAbsolute;
    Properties props;
    StringBuffer errorMessages = new StringBuffer();
    boolean helpRequested = false;
    protected boolean startInvisibly = false;
    protected boolean startMinimized = false;

    public BossConfig() {
        this(new String[0]);
    }

    public BossConfig(String[] args) {
        this.commandLineArguments = new String[args.length];
        System.arraycopy(args, 0, this.commandLineArguments, 0, args.length);
        this.parseArgs();
        this.props = this.readProperties();
    }

    public Properties getProperties() {
        return this.props;
    }

    protected void parseArgs() {
        int c;
        this.helpRequested = false;
        boolean argsError = false;
        if (this.commandLineArguments == null || this.commandLineArguments.length == 0) {
            return;
        }
        LongOpt[] longopts = new LongOpt[]{new LongOpt("startInvisibly", 0, null, 126), new LongOpt("startMinimized", 0, null, 96)};
        Getopt g = new Getopt("GaggleBoss", this.commandLineArguments, this.argSpecificationString, longopts);
        g.setOpterr(false);
        block7: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 112: {
                    this.propsFilename = g.getOptarg();
                    continue block7;
                }
                case 110: {
                    this.nameHelperUri = g.getOptarg();
                    continue block7;
                }
                case 63: {
                    int theOption = g.getOptopt();
                    if (theOption == 0) continue block7;
                    this.errorMessages.append("The option '" + (char)theOption + "' is not valid\n");
                    continue block7;
                }
                case 126: {
                    this.startInvisibly = true;
                    continue block7;
                }
                case 96: {
                    this.startMinimized = true;
                    continue block7;
                }
            }
            argsError = true;
        }
    }

    public String[] getPluginNames() {
        String[] keys = this.props.keySet().toArray(new String[0]);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < keys.length; ++i) {
            String propertyName = keys[i];
            if (!propertyName.toLowerCase().startsWith("plugin")) continue;
            list.add(this.props.get(propertyName));
        }
        return list.toArray(new String[0]);
    }

    public String getNameHelperUri() {
        return this.nameHelperUri;
    }

    public String getPropsFilename() {
        return this.propsFilename;
    }

    public boolean startInvisibly() {
        return this.startInvisibly;
    }

    public boolean startMinimized() {
        return this.startMinimized;
    }

    protected Properties readProperties() {
        if (this.propsFilename == null) {
            return new Properties();
        }
        System.out.println("BossConfig about to read from " + this.propsFilename);
        Properties projectProps = this.readPropertyFileAsText(this.propsFilename);
        System.out.println("props: " + projectProps);
        return projectProps;
    }

    public Properties readPropertyFileAsText(String filename) {
        String rawText = "";
        try {
            if (filename.trim().startsWith("jar://")) {
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                rawText = reader.getText();
            } else {
                File projectPropsFile = new File(this.absolutizeFilename(this.projectFileDirectoryAbsolute, filename));
                TextFileReader reader = new TextFileReader(projectPropsFile.getPath());
                reader.read();
                rawText = reader.getText();
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading properties file " + filename);
            e0.printStackTrace();
        }
        byte[] byteText = rawText.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(byteText);
        Properties newProps = new Properties();
        try {
            newProps.load(is);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return newProps;
    }

    protected String absolutizeFilename(File parentDirectory, String filename) {
        if (filename.trim().startsWith("/")) {
            return filename;
        }
        return new File(parentDirectory, filename).getPath();
    }
}

