### Name: xyplot
### Title: Methods implementing Lattice xyplots for flow data.
### Aliases: panel.xyplot.flowframe.time panel.xyplot.flowframe
###   panel.xyplot.flowset prepanel.xyplot.flowframe.time
###   prepanel.xyplot.flowframe prepanel.xyplot.flowset
###   xyplot,flowFrame,missing-method xyplot,formula,flowFrame-method
###   xyplot,formula,flowSet-method xyplot,formula,gateView-method
###   xyplot,formula,view-method xyplot,view,missing-method xyplot
### Keywords: methods dplot

### ** Examples


data(GvHD)
GvHD <- GvHD[pData(GvHD)$Patient %in% 5:6]

## a bivariate scatterplot
## by default ('smooth=TRUE') panel.smoothScatter is used
xyplot(`FSC-H` ~ `SSC-H`, GvHD[["s5a05"]], nbin = 100,
main="A single flowFrame")

## A non-smooth version of the same data
xyplot(`FSC-H` ~ `SSC-H`, GvHD[["s5a05"]], nbin = 100,
main="A single flowFrame", smooth=FALSE)

## Visual artifacts created by the pileup of margin events
xyplot(`FSC-H` ~ `SSC-H`, GvHD[["s5a05"]], nbin = 100,
main="A single flowFrame", margin=FALSE)

## simple bivariate scatter plot (a.k.a. dot plot)
## for the whole flowSet, conditioning on Patient and
## Visit
xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit, data = GvHD)

## several examples with time on the X axis
## first for a flowFrame
xyplot(GvHD[[1]])

## and for flowSets
xyplot(`FSC-H` ~ Time | Visit, GvHD, 
       smooth = FALSE, type = "l", 
       subset = (Patient == 5))

xyplot(`FSC-H` ~ Time | Patient+Visit, GvHD, 
       smooth = FALSE, type = "a",
       strip = FALSE, strip.left = TRUE,
       aspect = "xy")

## combine plots for two channels
ssc.time <- 

    xyplot(`SSC-H` ~ Time | factor(Patient):factor(Visit), GvHD, 
           smooth = FALSE, type = "a",
           strip = FALSE,
           strip.left = strip.custom(horizontal = TRUE),
           par.strip.text = list(lines = 3),
           between = list(y = rep(c(0, 0.5), c(6, 1))),
           scales = list(x = list(axs = "i"), y = list(draw = FALSE)),
           layout = c(1, 14))

fsc.time <- 
    xyplot(`FSC-H` ~ Time | factor(Patient):factor(Visit), GvHD, 
           smooth = FALSE, type = "a",
           strip = FALSE,
           strip.left = strip.custom(horizontal = TRUE),
           par.strip.text = list(lines = 3),
           between = list(y = rep(c(0, 0.5), c(6, 1))),
           scales = list(x = list(axs = "i"), y = list(draw = FALSE)),
           layout = c(1, 14))

plot(fsc.time, split = c(1, 1, 2, 1))
plot(ssc.time, split = c(2, 1, 2, 1), newpage = FALSE)

## saving plots as variables allows more manipulation
plot(update(fsc.time[8:14], layout = c(1, 7)),
     split = c(1, 1, 1, 2))

plot(update(ssc.time[8:14], layout = c(1, 7)),
     split = c(1, 2, 1, 2), newpage = FALSE)

## displaying filters
n2gate <- norm2Filter("SSC-H", "FSC-H")

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit, data = GvHD,
       filter=n2gate, subset=Patient==5)

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit,
       data=transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       smooth=FALSE, filter=n2gate, subset=Patient==5)

n2gate.results <- filter(GvHD, n2gate)

xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD,
       subset=Patient == "6",
       filter=n2gate.results, smooth=FALSE)




