### Name: gene.strip
### Title: Use the X:MAP database to find annotated gene structure and
###   generate a plot for multiple genes
### Aliases: gene.strip value.to.colour ps.value
### Keywords: misc

### ** Examples
 
   if(interactive()) {
     data(exonmap)
     xmapConnect()
     genes <- probeset.to.gene(featureNames(x.rma))
     gene.strip(genes,x.rma,list(1:3,4:6),type="mean-fc",col.range=c(-2,2))
     par(mfrow=c(2,2))
     gene.strip(genes,x.rma,list(1:3),type="mean-int",col.range=c(0,16),col=heat.colors(16),main="MCF7",show.legend=FALSE)
     gene.strip(genes,x.rma,list(4:6),type="mean-int",col.range=c(0,16),col=heat.colors(16),main="MCF10A",show.legend=FALSE)
     gene.strip(genes,x.rma,list(1:3),type="mean-int",col.range=c(0,16),col=heat.colors(16),main="MCF7",show.introns=TRUE,show.legend=FALSE)
     gene.strip(genes,x.rma,list(4:6),type="mean-int",col.range=c(0,16),col=heat.colors(16),main="MCF10A",show.introns=TRUE,show.legend=FALSE)

     fold.changes <- apply(exprs(x.rma)[1:10,],1,ps.value,gps=list(1:3,4:6),type="mean-fc")
     value.to.colour(fold.changes)
  }



