###################################################
### chunk number 1: rawdata
###################################################
library(edgeR)
set.seed(101)
n<-200
lib.sizes<-c(40000,50000,38000,40000)
p<-runif(n,min=.0001,.001)
mu<-outer(p,lib.sizes)
mu[1:5,3:4]<-mu[1:5,3:4]*8
y<-matrix(rnbinom(4*n,size=4,mu=mu),nrow=n)
rownames(y)<-paste("tag",1:nrow(y),sep=".")
y[1:10,]
d<-DGEList(data=y,group=rep(1:2,each=2),lib.size=lib.sizes)  # call constructor
d
names(d)


###################################################
### chunk number 2: moderation
###################################################
alpha<-alpha.approxeb(d)
alpha
ms<-deDGE(d,alpha=alpha$alpha)
ms


###################################################
### chunk number 3: MAplot
###################################################
adj.p<-p.adjust(ms$exact,"fdr")
k<-(adj.p<.05)
plotMA( ms, col=c("black","blue")[k+1])


###################################################
### chunk number 4: boxplot
###################################################
boxplot(as.data.frame(sqrt(d$data)))


###################################################
### chunk number 5: topTags
###################################################
topTags(ms)


###################################################
### chunk number 6: poisson
###################################################
set.seed(101)
y<-matrix(rpois(4*n,lambda=mu),nrow=n)
d<-DGEList(data=y,group=rep(1:2,each=2),lib.size=lib.sizes)
ms<-deDGE(d,doPoisson=TRUE)
par(mfrow=c(1,2))
boxplot(as.data.frame(sqrt(d$data)))
boxplot(as.data.frame(sqrt(ms$pseudo)))


###################################################
### chunk number 7: poissonstats
###################################################
adj.p<-p.adjust(ms$exact,"fdr")
k<-(adj.p<.05)
plotMA(ms,col=c("black","blue")[k+1])
topTags(ms)


