### Name: ArrayOutliers
### Title: Multivariate outlier detection based on PCA of QA statistics
### Aliases: ArrayOutliers afxsubDEG afxsubQC s12c s12cDEG s12cQC ILM1
###   itnQA maqcQA ilmQA spikQA fig3map
### Keywords: models

### ** Examples

library(simpleaffy)
setQCEnvironment("hgu133acdf")  # no CDF corresponding to tag array
if ( require("mvoutData") ) { 
 data(s12c)
 data(s12cQC)
 data(s12cDEG)
 library(affyPLM)
 s12cPset = fitPLM(s12c)
 ao = ArrayOutliers(s12c, alpha=0.05, qcOut=s12cQC, plmOut=s12cPset, degOut=s12cDEG)
 ao
 }
if (require("lumiBarnes")) {
 library(lumiBarnes)
 data(lumiBarnes)
 ArrayOutliers(lumiBarnes, alpha=0.05)
 lb2 = lumiBarnes
 exprs(lb2)[1:20000,1:2] = 10000*exprs(lb2)[1:20000,1:2]
 ArrayOutliers(lb2, alpha=0.05)
 }
data(maqcQA) # affy
ArrayOutliers(maqcQA[,-c(1:2)], alpha=.05)
ArrayOutliers(maqcQA[,-c(1:2)], alpha=.01)
data(ilmQA) # illumina
ArrayOutliers(data.frame(ilmQA), alpha=.01)
data(itnQA) # 507 arrays from ITN
ArrayOutliers(itnQA, alpha=.01)



