### Name: getOrthologousProbesets
### Title: Find orthologous/homologous probe sets present in a target set
###   using a mapping table
### Aliases: getOrthologousProbesets
### Keywords: manip

### ** Examples

data(orthologs_example)

##select the first 3 probe sets listed in 'table_mouse' and their orthologs in 'table_human'
##note that no ortholog is found for the top mouse probe set
table_mouse[1:3,]
orthops<-getOrthologousProbesets(table_mouse[1:3,1],table_human,ortho)
orthops[[1]]

##the second item returned contains the values associated with orthologs (second column of 'table_human')
orthops[[2]]

##calculates, for each mouse probe set, the median orthologous log fold change (in case of multiple orthologs)
##(in this case log fold changes need to be in the second column of 'table_mouse')
orthops<-getOrthologousProbesets(table_mouse[1:3,1],table_human,ortho,'median')
orthops[[2]]

##for each mouse probe set having multiple orthologous human probe sets
##select the orthologous probe set with the smallest p-value (column 4 of 'table_human')
orthops<-getOrthologousProbesets(table_mouse[1:3,1],table_human[,c(1,4)],ortho,'min',forceProbesetSelection=TRUE)
orthops[[1]]

##orthologous probe set selection can based on arbitrary functions
##e.g. select the 2 orthologous probe sets with the smallest p-values
orthops<-getOrthologousProbesets(table_mouse[1:3,1],table_human[,c(1,4)],ortho,function(x){sort(x)[1:2]},forceProbesetSelection=TRUE)
orthops[[1]]



