### Name: getGENEONTOLOGY
### Title: Find Gene Ontology (GO) annotation
### Aliases: getGENEONTOLOGY
### Keywords: manip

### ** Examples

##example Affymetrix annotation file and its location
annotationFile<-'HG-U133_Plus_2_annot_part.csv'
dataDirectory<-system.file('data',package='annotationTools')

##load annotation file
annotation<-read.csv(paste(dataDirectory,annotationFile,sep='/'),colClasses='character')

##get gene GO biological process (full information)
myPS<-c('117_at','1007_s_at','1552288_at',NA,'xyz_at')
getGENEONTOLOGY(myPS,annotation)

##get gene GO biological process terms only
getGENEONTOLOGY(myPS,annotation,specifics=2)

##track origin of annotation failure for the 3 last probe set IDs
getGENEONTOLOGY(myPS,annotation,diagnose=TRUE)

##GO molecular functions are contained in column 33 of the annotation
colnames(annotation)

##get gene GO molecular functions
getGENEONTOLOGY(myPS,annotation,GOcol=33)



