###################################################
### chunk number 1: 
###################################################
library(altcdfenvs)


###################################################
### chunk number 2: 
###################################################
library(plasmodiumanophelescdf)


###################################################
### chunk number 3: 
###################################################
planocdf <- wrapCdfEnvAffy(plasmodiumanophelescdf, 712, 712, "plasmodiumanophelescdf")
print(planocdf)


###################################################
### chunk number 4: 
###################################################
ids <- geneNames(planocdf)
ids.pf <- ids[grep("^Pf", ids)]


###################################################
### chunk number 5: 
###################################################
## subset the object to only keep probe sets of interest
plcdf <- planocdf[ids.pf]
print(plcdf)


###################################################
### chunk number 6: 
###################################################
filename <- system.file("exampleData", "Plasmodium-Probeset-IDs.txt",
                             package="altcdfenvs")
ids.pf <- scan(file = filename, what = "")
plcdf <- planocdf[ids.pf]
print(plcdf)


###################################################
### chunk number 7: 
###################################################
plcdf@envName <- "Plasmodium ids only"
print(plcdf)


