### Name: matchAffyProbes
### Title: Match the probes on an Affymetrix array
### Aliases: matchAffyProbes mmProbes
### Keywords: manip

### ** Examples


library(hgu133aprobe)

filename <- system.file("exampleData", "sample.fasta",
                        package="altcdfenvs")

fasta.seq <- readFASTA(filename)

targets <- unlist(lapply(fasta.seq, "[[", "seq"))
names(targets) <- lapply(fasta.seq, "[[", "desc")
names(targets) <- sub("^>.+\\|(NM[^ \\|]+|Hs[^ \\|]+)\\|? .+$", "\\1",
                      names(targets))

m <- matchAffyProbes(hgu133aprobe,
                     targets,
                     "HG-U133A")




