###################################################
### chunk number 1: 
###################################################
library(golubEsets)
oldopt <- options(digits=3)
on.exit( {options(oldopt)} )
options(width=70)
if (interactive()) { 
    options(error=recover)
}
set.seed(123)


###################################################
### chunk number 2: 
###################################################
library(adSplit) 


###################################################
### chunk number 3: 
###################################################
library(golubEsets) 
data(Golub_Merge) 


###################################################
### chunk number 4: 
###################################################
e <- exprs(Golub_Merge)
vars <- apply(e, 1, var)
e <- e[vars > quantile(vars,0.9),]

diana2means(e)
diana2means(e, return.cut=TRUE)


###################################################
### chunk number 5: 
###################################################
x <- diana2means(e, return.cut=TRUE)
x$cut


###################################################
### chunk number 6: 
###################################################
adSplit(Golub_Merge, "GO:0006915", "hu6800")


###################################################
### chunk number 7: 
###################################################
adSplit(Golub_Merge, "GO:0007165", "hu6800")


###################################################
### chunk number 8: 
###################################################
adSplit(Golub_Merge, "GO:0007165", "hu6800", max.probes=7000)


###################################################
### chunk number 9: 
###################################################
EID2PSenv <- makeEID2PROBESenv(hu6800ENTREZID)


###################################################
### chunk number 10: 
###################################################
drawRandomPS(10, EID2PSenv, ls(EID2PSenv))


###################################################
### chunk number 11: 
###################################################
scores <- randomDiana2means(20, exprs(Golub_Merge), "hu6800", ndraws = 1000) 


###################################################
### chunk number 12: 
###################################################
scores2 <- randomDiana2means(20, exprs(Golub_Merge), "hu6800", 
                            ndraws = 1000, ignore.genes=5) 
par(mfrow=c(1,2))
hist(scores,  nclass=30, main="", col="grey")
hist(scores2, nclass=30, main="", col="grey")


###################################################
### chunk number 13: 
###################################################
glutamSplits <- adSplit(Golub_Merge, "KEGG:00251", "hu6800", B=1000) 


###################################################
### chunk number 14: 
###################################################
print(glutamSplits)


###################################################
### chunk number 15: 
###################################################
x <- adSplit(Golub_Merge, c("GO:0007165","GO:0006915"), "hu6800", max.probes=7000)
print(x)


###################################################
### chunk number 16: 
###################################################
x <- adSplit(Golub_Merge, "KEGG", "hu6800")


###################################################
### chunk number 17: 
###################################################
print(x)


###################################################
### chunk number 18: 
###################################################
data(golubKEGGSplits)
print(golubKEGGSplits)
summary(golubKEGGSplits$qvalues)


###################################################
### chunk number 19: 
###################################################
data(golubKEGGSplits)
hist(golubKEGGSplits)


###################################################
### chunk number 20: 
###################################################
image(golubKEGGSplits, filter.fdr=0.3, outfile="splitSet.eps", res=300)


