###################################################
### chunk number 1: 
###################################################
library(SMAP)


###################################################
### chunk number 2: 
###################################################
data(GBM)
obs <- SMAPObservations(value=as.numeric(GBM[,2]),
                        chromosome=as.character(GBM[,3]),
                        startPosition=as.numeric(GBM[,4]),
                        endPosition=as.numeric(GBM[,5]),
                        name="G24460",
                        reporterId=as.character(GBM[,1]))


###################################################
### chunk number 3: 
###################################################
plot(obs, ylab="ratio", ylim=c(0,2))


###################################################
### chunk number 4: 
###################################################
ids <- which(chromosome(obs) == "9")
plot(obs[ids], ylab="ratio", ylim=c(0,2),
main=paste(name(obs), "chromosome 9"))


###################################################
### chunk number 5: 
###################################################
init.means <- c(0.4, 0.7, 1, 1.3, 1.6, 3)
init.sds <- rep(0.1, 6)
phi <- cbind(init.means, init.sds)
hmm <- SMAPHMM(noStates=6, Phi=phi, initTrans=0.02)
hmm


###################################################
### chunk number 6: 
###################################################
    profile <- smap(hmm, obs, verbose=2)


###################################################
### chunk number 7: 
###################################################
Q(profile)


###################################################
### chunk number 8: 
###################################################
Phi(HMM(profile))


###################################################
### chunk number 9: 
###################################################
## Plot results of all data:
plot(profile, ylab="ratio", ylim=c(0,2))


###################################################
### chunk number 10: 
###################################################
## Plot chromosomes with aberrations:
chrom.selection <- as.character(c(1, 6, 7, 8, 9, 10, 15, 19, 20))
selection <- which(chromosome(obs) %in% chrom.selection)
plot(profile[selection], ylab="ratio", ylim=c(0, 2))


###################################################
### chunk number 11: 
###################################################
## Plot all chromosomes separately:
par(mfrow=c(3, 3))
for (c in chrom.selection) {
    ids <- which(chromosome(obs) == c)
    plot(profile[ids], ylab="ratio", ylim=c(0, 2), main=c)
}


