### Name: posToProbeAnno
### Title: Function for creating a probeAnno environment
### Aliases: posToProbeAnno posToProbeAnnoEnvironment createProbeAnno
### Keywords: manip

### ** Examples

 exPos <- read.delim(file.path(system.file("exData",package="Ringo"),
                     "MOD_2003-12-05_SUZ12_1in2.pos"),
                     header=TRUE,as.is=TRUE)
 str(exPos)
 exProbeAnno <- posToProbeAnno(exPos,
     genome="M. musculus (assembly mm8)",
     microarrayPlatform="NimbleGen 2005-06-17_Ren_MM5Tiling_Set1")
 ## is equivalent to 
 exProbeAnno2 <- posToProbeAnno(file.path(
    system.file("exData",package="Ringo"),"MOD_2003-12-05_SUZ12_1in2.pos"),
    genome="M. musculus (assembly mm8)",
    microarrayPlatform="NimbleGen 2005-06-17_Ren_MM5Tiling_Set1")
 ls(exProbeAnno)
 chromosomeNames(exProbeAnno2)



