### Name: BezierCurve-class
### Title: Class "BezierCurve": A class to describe a Bezier curve
### Aliases: BezierCurve-class BezierCurve cPoints pointList bezierPoints
###   bLines show,BezierCurve-method lines,BezierCurve-method
###   bLines,BezierCurve-method bezierPoints,BezierCurve-method
###   pointList,BezierCurve-method cPoints,BezierCurve-method
### Keywords: classes

### ** Examples

V <- letters[1:10]
M <- 1:4
g1 <- randomGraph(V, M, .2)
z <- agopen(g1,"foo")
x <- AgEdge(z)  ## list of AgEdge objects
x[[1]]  ## AgEdge
a <- splines(x[[1]])[[1]]
a  ## BezierCurve

cPoints(a)
pointList(a)
bezierPoints(a)



