### Name: coverage
### Title: Coverage across a set of ranges
### Aliases: coverage coverage,IRanges-method
###   coverage,MaskCollection-method
### Keywords: methods

### ** Examples

  x <- IRanges(start=c(-2L, 6L, 9L, -4L, 1L, 0L, -6L, 10L),
               width=c( 5L, 0L, 6L,  1L, 4L, 3L,  2L,  3L))
  coverage(x, start=-6, end=20)  # 'start' and 'end' must be specified for
                                 # an IRanges object.
  coverage(shift(x, 2), start=-6, end=20)
  coverage(restrict(x, 1, 10), start=-6, end=20)
  coverage(reduce(x), start=-6, end=20)
  coverage(gaps(x, start=-6, end=20), start=-6, end=20)

  mask1 <- Mask(mask.width=29, start=c(11, 25, 28), width=c(5, 2, 2))
  mask2 <- Mask(mask.width=29, start=c(3, 10, 27), width=c(5, 8, 1))
  mask3 <- Mask(mask.width=29, start=c(7, 12), width=c(2, 4))
  mymasks <- append(append(mask1, mask2), mask3)
  coverage(mymasks)



