### Name: XIntegerViews-class
### Title: The XIntegerViews class
### Aliases: class:XIntegerViews XIntegerViews-class XIntegerViews
###   Views,XInteger-method Views,integer-method show,XIntegerViews-method
###   [[,XIntegerViews-method [[<-,XIntegerViews-method
###   ==,XIntegerViews,XIntegerViews-method
###   ==,XIntegerViews,XInteger-method ==,XIntegerViews,integer-method
###   ==,XInteger,XIntegerViews-method ==,integer,XIntegerViews-method
###   !=,XIntegerViews,XIntegerViews-method
###   !=,XIntegerViews,XInteger-method !=,XIntegerViews,integer-method
###   !=,XInteger,XIntegerViews-method !=,integer,XIntegerViews-method
###   as.integer,XIntegerViews-method
### Keywords: methods classes

### ** Examples

  ## One standard way to create an XIntegerViews object is to use
  ## the Views() constructor:
  subject <- XInteger(6, c(45, 67, 84, 67, 45, 78))
  v4 <- Views(subject, 3:0, 5:8)
  v4
  subject(v4)
  length(v4)
  start(v4)
  end(v4)
  width(v4)

  ## Attach a comment to views #3 and #4:
  names(v4)[3:4] <- "out of limits"
  names(v4)

  ## A more programatical way to "tag" the "out of limits" views:
  names(v4)[start(v4) < 1 | length(subject(v4)) < end(v4)] <- "out of limits"
  ## or just:
  names(v4)[length(subject(v4)) < width(v4)] <- "out of limits"

  ## Extract a view as an XInteger object:
  v4[[2]]

  ## It is an error to try to extract an "out of limits" view:
  #v4[[3]] # Error!

  ## Here the first view doesn't even overlap with the subject:
  Views(XInteger(6, c(97, 97, 97, 45, 45, 98)), -3:4, -3:4 + c(3:6, 6:3))



