### Name: TypedList-class
### Title: Typed Lists
### Aliases: TypedList-class elementClass elementClass,TypedList-method
###   elements elements,TypedList-method length,TypedList-method
###   names,TypedList-method names<-,TypedList-method
###   [,TypedList,ANY,ANY,ANY-method [<-,TypedList,ANY,ANY,ANY-method
###   [[,TypedList-method [[<-,TypedList-method
###   append,TypedList,TypedList-method c,TypedList-method
###   as.list,TypedList-method coerce,TypedList,list-method
###   unlist,TypedList-method lapply,TypedList,function-method
###   show,TypedList-method
### Keywords: methods classes

### ** Examples

  ## demonstrated on RangesList, as TypedList is virtual

  range1 <- IRanges(start=c(1,2,3), end=c(5,2,8))
  range2 <- IRanges(start=c(15,45,20,1), end=c(15,100,80,5))
  collection <- RangesList(range1, range2)

  ## names
  names(collection) <- c("one", "two")
  names(collection)
  names(collection) <- NULL # clear names
  names(collection)
  names(collection) <- "one"
  names(collection) # c("one", NA)

  ## extraction
  collection[[1]] # range1
  collection[["1"]] # NULL, does not exist
  collection[["one"]] # range1
  collection[[NA_integer_]] # NULL

  ## subsetting
  collection[numeric()] # empty
  collection[NULL] # empty
  collection[] # identity
  collection[c(TRUE, FALSE)] # first element
  collection[2] # second element
  collection[c(2,1)] # reversed
  collection[-1] # drop first

  ## combining
  col1 <- RangesList(one = range1, range2)
  col2 <- RangesList(two = range2, one = range1)
  col3 <- RangesList(range2)
  append(col1, col2, 1)
  append(col1, col2, -5)
  c(col1, col2, col3)

  ## get the starts of each Ranges
  lapply(col1, start)



