### Name: Sequence-class
### Title: Sequence objects
### Aliases: class:Sequence Sequence-class Sequence class:SequenceORvector
###   SequenceORvector-class SequenceORvector subseq
###   subseq,SequenceORvector-method rep,Sequence-method
###   [<-,Sequence,ANY,ANY,ANY-method !=,Sequence,Sequence-method
###   class:XSequence XSequence-class XSequence length,XSequence-method
###   subseq,XSequence-method coerce,integer,XSequence-method
###   coerce,numeric,XSequence-method class:XRaw XRaw-class XRaw
###   class:XInteger XInteger-class XInteger as.integer,XInteger-method
###   as.vector,XInteger,missing-method coerce,integer,XInteger-method
###   [,XInteger,ANY,ANY,ANY-method show,XInteger-method
###   ==,XInteger,XInteger-method class:XNumeric XNumeric-class XNumeric
###   as.numeric,XNumeric-method as.vector,XNumeric,missing-method
###   coerce,numeric,XNumeric-method [,XNumeric,ANY,ANY,ANY-method
###   show,XNumeric-method ==,XNumeric,XNumeric-method class:XRle
###   XRle-class XRle length,XRle-method rep,XRle-method
###   reverse,XRle-method ==,XRle,XRle-method [,XRle,ANY,ANY,ANY-method
###   class:XRleInteger XRleInteger-class XRleInteger
###   Arith,integer,XRleInteger-method Arith,XRleInteger,integer-method
###   Arith,XRleInteger,XRleInteger-method as.integer,XRleInteger-method
###   as.vector,XRleInteger,missing-method
###   coerce,integer,XRleInteger-method show,XRleInteger-method
### Keywords: methods classes

### ** Examples

  x1 <- XInteger(12, c(-1:10))
  x1
  length(x1)

  ## Subsetting
  x2 <- XInteger(99999, sample(99, 99999, replace=TRUE) - 50)
  x2
  subseq(x2, start=10)
  subseq(x2, start=-10)
  subseq(x2, start=-20, end=-10)
  subseq(x2, start=10, width=5)
  subseq(x2, end=10, width=5)
  subseq(x2, end=10, width=0)

  x1[length(x1):1]
  x1[length(x1):1, drop=FALSE]



