### Name: IntervalTree-class
### Title: Interval Search Trees
### Aliases: IntervalTree-class IntervalTree
###   coerce,IRanges,IntervalTree-method coerce,Ranges,IntervalTree-method
###   coerce,IntervalTree,IRanges-method length,IntervalTree-method overlap
###   overlap,IntervalTree,Ranges-method overlap,Ranges,Ranges-method
###   overlap,Ranges,missing-method \%in\%,Ranges,Ranges-method
### Keywords: classes methods

### ** Examples

  query <- IRanges(c(1, 4, 9), c(5, 7, 10))
  subject <- IRanges(c(2, 2, 10), c(2, 3, 12))
  tree <- IntervalTree(subject)

  ## at most one hit per query
  overlap(tree, query, multiple = FALSE) # c(2, NA, 3)

  ## allow multiple hits
  overlap(tree, query)

  ## overlap as long as distance <= 1
  overlap(tree, query, maxgap = 1)

  ## shortcut
  overlap(subject, query)

  ## query and subject are easily interchangeable
  query <- IRanges(c(1, 4, 9), c(5, 7, 10))
  subject <- IRanges(c(2, 2), c(5, 4))
  tree <- IntervalTree(subject)
  t(overlap(tree, query))
  # the same as:
  overlap(query, subject)

  ## one Ranges with itself
  overlap(query)



