###################################################
### chunk number 1:  eval=FALSE
###################################################
## vignette(all=FALSE)
## edit(vignette("GraphAlignment"))


###################################################
### chunk number 2: 
###################################################
options(width = 40)
options(digits = 3);
library(GraphAlignment)


###################################################
### chunk number 3: 
###################################################
library(GraphAlignment)

ex<-GenerateExample(dimA=22, dimB=22, filling=.5, 
    covariance=.6, symmetric=TRUE, numOrths=10, correlated=seq(1,18))


###################################################
### chunk number 4: 
###################################################
pinitial<-InitialAlignment(psize=34, r=ex$r, mode="reciprocal")


###################################################
### chunk number 5: 
###################################################
lookupLink<-seq(-2,2,.5)


###################################################
### chunk number 6: 
###################################################
linkParams<-ComputeLinkParameters(ex$a, ex$b, pinitial, lookupLink)


###################################################
### chunk number 7: 
###################################################
lookupNode<-c(-.5,.5,1.5)
nodeParams<-ComputeNodeParameters(dimA=22, dimB=22, ex$r,
    pinitial, lookupNode)


###################################################
### chunk number 8: 
###################################################
al<-AlignNetworks(A=ex$a, B=ex$b, R=ex$r, P=pinitial, 
    linkScore=linkParams$ls,
    selfLinkScore=linkParams$ls,
    nodeScore1=nodeParams$s1, nodeScore0=nodeParams$s0,
    lookupLink=lookupLink, lookupNode=lookupNode,
    bStart=.1, bEnd=30,
    maxNumSteps=50)


###################################################
### chunk number 9: 
###################################################
ComputeScores(A=ex$a, B=ex$b, R=ex$r, P=al, 
    linkScore=linkParams$ls,
    selfLinkScore=linkParams$ls,
    nodeScore1=nodeParams$s1, nodeScore0=nodeParams$s0,
    lookupLink=lookupLink, lookupNode=lookupNode,
    symmetric=TRUE)


###################################################
### chunk number 10: 
###################################################
AnalyzeAlignment(A=ex$a, B=ex$b, R=ex$r, P=al, lookupNode,
    epsilon=.5)


###################################################
### chunk number 11: 
###################################################
ex<-GenerateExample(30, 30, filling=1, covariance=.95,
    numOrths=20, symmetric=FALSE)
a=ex$a;b=ex$b
a[a>.5]=1;a[a<=.5]=0
b[b>.5]=1;b[b<=.5]=0
pinitial<-InitialAlignment(psize=40, r=ex$r, mode="reciprocal")
lookupLink<-c(-.5,.5,1.5)
linkParams<-ComputeLinkParameters(a, b, pinitial, lookupLink,
    clamp=FALSE)


###################################################
### chunk number 12: 
###################################################
lookupNode<-c(-.5,.5,1.5)
nsS0<-c(.025,-.025)
nsS1<-c(-.025,4)
al<-AlignNetworks(A=a, B=b, R=ex$r, P=pinitial,
    linkScore=linkParams$ls,
    selfLinkScore=linkParams$lsSelf,
    nodeScore1=nsS1, nodeScore0=nsS0,
    lookupLink=lookupLink, lookupNode=lookupNode,
    bStart=.1, bEnd=100,
    maxNumSteps=500, clamp=FALSE, directed=TRUE)


###################################################
### chunk number 13: 
###################################################
A <- matrix(c(0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1), ncol = 4);
B <- matrix(c(0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1), ncol = 4);
R <- matrix(c(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), ncol = 4);


###################################################
### chunk number 14: 
###################################################
p0 <- c(1,3,4,5,2);
psize <- 5;


###################################################
### chunk number 15: 
###################################################
AlignedPairs(A, B, p0);


###################################################
### chunk number 16: 
###################################################
lookupLink <- c(-0.5, 0.5, 1.5);


###################################################
### chunk number 17: 
###################################################
lookupNode <- c(-0.5, 0.5, 1.5);


###################################################
### chunk number 18: 
###################################################
linkParams;
nodeParams;


###################################################
### chunk number 19: 
###################################################
al <- AlignNetworks(A, B, R, p0, linkParams$ls, linkParams$lsSelf, nodeParams$s1, nodeParams$s0, lookupLink, lookupNode, bStart = 0.001, bEnd = 1000, maxNumSteps = 100, clamp = TRUE);


###################################################
### chunk number 20: 
###################################################
linkParams <- ComputeLinkParameters(A, B, al, lookupLink);
nodeParams <- ComputeNodeParameters(dim(A)[1], dim(B)[1], R, al, lookupNode);


###################################################
### chunk number 21: 
###################################################
al == AlignNetworks(A, B, R, al, linkParams$ls, linkParams$lsSelf, nodeParams$s1, nodeParams$s0, lookupLink, lookupNode, bStart = 0.001, bEnd = 1000, maxNumSteps = 100, clamp = TRUE);


###################################################
### chunk number 22: 
###################################################
al;
AlignedPairs(A, B, al);


###################################################
### chunk number 23: 
###################################################
ComputeScores(A, B, R, al, linkParams$ls, linkParams$lsSelf, nodeParams$s1, nodeParams$s0, lookupLink, lookupNode, symmetric = TRUE, clamp = TRUE);


