### Name: ExonArray-class
### Title: Class "ExonArray" representing probe level exon array data from
###   Affymetrix
### Aliases: ExonArray-class show,ExonArray-method drawGD,ExonArray-method
### Keywords: classes

### ** Examples

if(interactive()){
data("unrData", package="GenomeGraphs")
library(biomaRt)
mart = useMart("ensembl", dataset="hsapiens_gene_ensembl")

title = new("Title", title ="ENSG00000009307", dp = DisplayPars(color = "darkslategray"))
exmapcol = rep("khaki", length(unrNProbes))
exmapcol[28]="darkred"
probeSetCol = rep("grey", length(unrNProbes))
probeSetCol[27:28]="darkslategray"
probeSetLwd = rep(1, length(unrNProbes))
probeSetLwd[27:28]=3

exon = new("ExonArray", intensity = unrData, probeStart = unrPositions[,3], probeEnd=unrPositions[,4], probeId = as.character(unrPositions[,1]), nProbes = unrNProbes, dp = DisplayPars(color = "blue", mapColor = exmapcol, probeSetColor = probeSetCol, probeSetLwd = probeSetLwd), displayProbesets=FALSE)
exon2 = new("ExonArray", intensity = unrData, probeStart = unrPositions[,3], probeEnd=unrPositions[,4], probeId = as.character(unrPositions[,1]), nProbes = unrNProbes, dp = DisplayPars(color = "blue", mapColor = exmapcol, probeSetColor = probeSetCol, probeSetLwd = probeSetLwd, plotMap=FALSE), displayProbesets=TRUE)

affyModel = new("GeneModel", exonStart = unrPositions[,3], exonEnd =  unrPositions[,4])
gene = new("Gene", id = "ENSG00000009307", biomart = mart)
transcript = new("Transcript", id ="ENSG00000009307" , biomart = mart)
legend = new("Legend", legend = c("affyModel","gene"), dp = DisplayPars(color= c("darkgreen","orange")))

gdPlot(list(title,exonarray1 = exon2,exonarray2= exon, AffymetrixModel= affyModel, gene, transcript, legend), minBase = min(exon@probeStart), maxBase=max(exon@probeEnd))
}



