### Name: geneContribution
### Title: Gene contribution or proportion of genes in pedigree by
###   individual
### Aliases: geneContribution
### Keywords: array misc

### ** Examples

  ped <- generatePedigree(nId=5, nGeneration=4, nFather=1, nMother=2)
  geneContribution(ped)
  geneContribution(ped, relative=FALSE)
  ## geneContribution(ped[5:15, ]) ## needs [ method

  ## More than one father example
  ped <- data.frame(     id=c(1, 2, 3, 4, 5, 6, 7),
                    father1=c(0, 0, 0, 2, 1, 1, 2),
                    father2=c(0, 0, 0, 0, 0, 2, 0),
                     mother=c(0, 0, 0, 0, 3, 3, 3),
                    generat=c(1, 1, 1, 2, 2, 2, 2))
  ped <- Pedigree(ped, ascendant=c("father1", "father2", "mother"),
                  ascendantSex=c(1, 1, 2), ascendantLevel=c(1, 1, 1),
                  unknown=0, generation="generat")
  geneContribution(ped)



