### Name: floodFill
### Title: Filling matrix data with flood fill algorithm
### Aliases: floodFill floodFill,array-method fillHull
###   fillHull,IndexedImage-method
### Keywords: file

### ** Examples

if (interactive()) {
  data(imageWithHoles)

  display(x, main="Original image")
  display(floodFill(x,c(5,5),tolerance=0.2))
  display(floodFill(x,c(40,40),tolerance=0.2))

  mask = x
  mask[mask>0.3]=1
  mask[mask<=0.3]=0

  y = floodFill(mask,c(40,40),2)
  class(y) = "IndexedImage"
  display(y, main="Indexed mask with holes")
  
  y = fillHull(y)
  display(y, main="Indexed mask without holes")

  rgb = channel(normalize(y), "rgb")
  rgb = floodFill(rgb, c(1,1), "red")
  rgb = floodFill(rgb, c(50,50), "blue")
  rgb = floodFill(rgb, c(150,150), "green")
  display(rgb)
}


