### Name: cmp.similarity
### Title: Compute similarity between two compounds using their descriptors
### Aliases: cmp.similarity
### Keywords: utilities

### ** Examples

# load sample database from web
db <- cmp.parse("http://bioweb.ucr.edu/ChemMineV2/static/example_db.sdf")
# compare two compounds in the database:
attach(db)              
cmp.similarity(descdb[[1]], descdb[[2]])
detach(db)

# or load a structure from its SDF
query <- cmp.parse1(
    "http://bioweb.ucr.edu/ChemMineV2/compound/Aurora/b32:NNQS2MBRHAZTI===/sdf")
# compare it against a structure in database
cmp.similarity(query, db$descdb[[2]])



