### Name: cghSeg
### Title: Class to contain and describe segmented array comparative
###   genomic hybridization data.
### Aliases: class:cghSeg cghSeg cghSeg-class copynumber,cghSeg-method
###   copynumber<-,cghSeg,matrix-method segmented,cghSeg-method
###   segmented<-,cghSeg,matrix-method chromosomes,cghSeg-method
###   bpstart,cghSeg-method bpend,cghSeg-method initialize,cghSeg-method
###   plot.cghSeg,cghSeg,missing-method
### Keywords: classes

### ** Examples


        # create an instance of cghSeg
        new("cghSeg")
        
        # load an instance of cghSeg
        data(WiltingSeg)

        # plot the first sample
        # plot.cghSeg(WiltingSeg[,1])
        # first three chromosomes
        # plot.cghSeg(WiltingSeg[chromosomes(WiltingSeg)==1,1])
        
        # get the copynumber values of the third and fourth sample
        log2ratios <- copynumber(WiltingSeg[,3:4])
        
        # get the names of the samples
        sampleNames(WiltingSeg)
        
        # get the names of the array elements
        featureNames(WiltingSeg)




