### Name: toComplex
### Title: Turning a DNA sequence into a vector of complex numbers
### Aliases: toComplex toComplex,DNAString-method
###   as.complex,DNAString-method
### Keywords: methods

### ** Examples

  seq <- DNAString("accacctgaccattgtcct")
  baseValues1 <- c(A=1+0i, G=0+1i, T=-1+0i, C=0-1i)
  toComplex(seq, baseValues1)

  ## GC content:
  baseValues2 <- c(A=0, C=1, G=1, T=0)
  sum(as.integer(toComplex(seq, baseValues2)))
  ## Note that there are better ways to do this (see ?alphabetFrequency)



