### Name: phiX174Phage
### Title: Versions of bacteriophage phiX174 complete genome and sample
###   short reads
### Aliases: phiX174Phage srPhiX174 quPhiX174 wtPhiX174
### Keywords: datasets

### ** Examples

data(phiX174Phage)
nchar(phiX174Phage)
genBankPhage <- phiX174Phage[[1]]
genBankSubstring <- substring(genBankPhage, 2793-34, 2811+34)

data(srPhiX174)
srPhiX174
quPhiX174
summary(wtPhiX174)

alignPhiX174 <-
  pairwiseAlignment(srPhiX174, genBankSubstring,
                    patternQuality = SolexaQuality(quPhiX174),
                    subjectQuality = SolexaQuality(99L),
                    type = "subjectOverlap")
summary(alignPhiX174, weight = wtPhiX174)



