### Name: PDict-class
### Title: PDict objects
### Aliases: class:PreprocessedTB PreprocessedTB-class PreprocessedTB
###   length,PreprocessedTB-method width,PreprocessedTB-method tb
###   tb,PreprocessedTB-method tb.width tb.width,PreprocessedTB-method
###   initialize,PreprocessedTB-method duplicated,PreprocessedTB-method
###   class:Twobit Twobit-class Twobit show,Twobit-method
###   initialize,Twobit-method class:ACtree ACtree-class ACtree
###   show,ACtree-method [,ACtree,ANY,ANY,ANY-method
###   as.matrix,ACtree-method initialize,ACtree-method class:ACtree2
###   ACtree2-class ACtree2 show,ACtree2-method initialize,ACtree2-method
###   class:PDict3Parts PDict3Parts-class PDict3Parts
###   length,PDict3Parts-method width,PDict3Parts-method
###   head,PDict3Parts-method tb,PDict3Parts-method
###   tb.width,PDict3Parts-method tail,PDict3Parts-method class:PDict
###   PDict-class length,PDict-method width,PDict-method names,PDict-method
###   names<-,PDict-method [[,PDict-method duplicated,PDict-method
###   patternFrequency patternFrequency,PDict-method class:TB_PDict
###   TB_PDict-class TB_PDict head,TB_PDict-method tb,TB_PDict-method
###   tb.width,TB_PDict-method tail,TB_PDict-method show,TB_PDict-method
###   class:MTB_PDict MTB_PDict-class MTB_PDict as.list,MTB_PDict-method
###   show,MTB_PDict-method PDict PDict,character-method
###   PDict,DNAStringSet-method PDict,XStringViews-method PDict,AsIs-method
### Keywords: methods classes

### ** Examples

  ## ---------------------------------------------------------------------
  ## A. NO HEAD AND NO TAIL (THE DEFAULT)
  ## ---------------------------------------------------------------------
  library(drosophila2probe)
  dict0 <- DNAStringSet(drosophila2probe$sequence)
  dict0                                # The original dictionary.
  length(dict0)                        # Hundreds of thousands of patterns.
  unique(nchar(dict0))                 # Patterns are 25-mers.

  pdict0 <- PDict(dict0)               # Store the original dictionary in
                                       # a PDict object (preprocessing).
  pdict0
  class(pdict0)
  length(pdict0)                       # Same as length(dict0).
  tb.width(pdict0)                     # The width of the (implicit)
                                       # Trusted Band.
  sum(duplicated(pdict0))
  table(patternFrequency(pdict0))      # 9 patterns are repeated 3 times.
  pdict0[[1]]
  pdict0[[5]]

  ## ---------------------------------------------------------------------
  ## B. NO HEAD AND A TAIL
  ## ---------------------------------------------------------------------
  dict1 <- c("ACNG", "GT", "CGT", "AC")
  pdict1 <- PDict(dict1, tb.end=2)
  pdict1
  class(pdict1)
  length(pdict1)
  width(pdict1)
  head(pdict1)
  tb(pdict1)
  tb.width(pdict1)
  width(tb(pdict1))
  tail(pdict1)
  pdict1[[3]]



