### Name: FLOC
### Title: Performs the FLOC algorithm
### Aliases: FLOC
### Keywords: cluster

### ** Examples


data(sample.bicData)     ## subset of sample.ExpressionSet from Biobase
residue(sample.bicData)  ##  0.3401921
resBic <- FLOC(sample.bicData, k=10, pGene=0.5,r=0.05,N=8,M=10,t=500)
resBic

## initialising samples of 2 biclusters
iniSample <- matrix(0, ncol=2, nrow=26)
## first bicluster initialised around Female cases
iniSample[pData(sample.bicData)$sex=="Female",1] <- 1
## second bicluster initialised around control cases
iniSample[pData(sample.bicData)$type=="Control",2] <- 1
resBic <- FLOC(sample.bicData, k=10, pGene=0.5, r=0.05, N=8, M=10, t=500, blocSample=iniSample)
resBic



