### Name: Agi4x44PreProcess-package
### Title: PreProcessing of Agilent 4x44 array data
### Aliases: Agi4x44PreProcess-package Agi4x44PreProcess
### Keywords: package

### ** Examples


        ## Not run:  reading target file and Agilent Feature Extraction data files
##D 
##D                targets=read.targets(infile="targets.txt")
##D                dd=read.AgilentFE(targets,makePLOT=TRUE)
##D         
## End(Not run)

        ## Not run: 
##D         data(dd)
##D         data(targets)   
##D         
## End(Not run)
        ## Not run: Non-Control replicated Probes

        ## Not run: 
##D         CV.rep.probes(dd,"hgug4112a.db",
##D                 foreground="MeanSignal",raw.data=TRUE,writeR=TRUE,targets)
##D         
## End(Not run)
        ## Not run: genes replicated - ensembl 

        ## Not run: 
##D         genes.rpt.agi(dd,annotation.package="hgug4112a.db",raw.data=TRUE,
##D                 WRITE.html=TRUE,REPORT=TRUE)
##D         
## End(Not run)
        ## Not run: NORMALIZATION (here the foreground and background are chosen)

        ## Not run: 
##D         ddNORM=BGandNorm(dd,BGmethod='half',NORMmethod='quantile',
##D                         foreground='MeanSignal',background='BGMedianSignal',
##D                         offset=50,makePLOTpre=TRUE,makePLOTpost=TRUE)
##D         
## End(Not run)
        ## Not run: FILTERING PROBES

        ## Not run: 
##D         ddFILT=filter.probes(ddNORM,
##D                 control=TRUE,
##D                 wellaboveBG=TRUE,
##D                 isfound=TRUE,
##D                 wellaboveNEG=TRUE,
##D                 sat=TRUE,
##D                 PopnOL=TRUE,
##D                 NonUnifOL=TRUE,
##D                 nas=TRUE,
##D                 limWellAbove=75,
##D                 limISF=75,
##D                 limNEG=75,
##D                 limSAT=75,
##D                 limPopnOL=75,
##D                 limNonUnifOL=75,
##D                 limNAS=100,
##D                 makePLOT=TRUE,annotation.package="hgug4112a.db",flag.counts=TRUE,targets)
##D         
## End(Not run)
        ## Not run: SUMMARIZING PROBES

        ## Not run: 
##D         ddPROC=summarize.probe(ddFILT,makePLOT=TRUE,targets)
##D         
## End(Not run)
        ## Not run: CREATING EXPRESIONSET OBJECT

        ## Not run: 
##D         esetPROC=build.eset(ddPROC,targets,makePLOT=TRUE,
##D                 annotation.package="hgug4112a.db")
##D         dim(esetPROC)
##D 
##D         
## End(Not run)
        ## Not run: WRITING EXPRESIONSET OBJECT: ProcessedData.txt

        ## Not run: 
##D         write.eset(esetPROC,ddPROC,"hgug4112a.db",targets)
##D         
## End(Not run)

        ## Not run:  MAPPING VARIABLE
        ## Not run: 
##D         mappings=build.mappings(esetPROC,annotation.package="hgug4112a.db")
##D         names(mappings)
##D 
##D         
## End(Not run)

        ## Not run: Gene Set Enrichment Analysis at: http://www.broad.mit.edu/gsea

        ## Not run: 
##D         gsea.files(esetPROC,targets,annotation.package="hgug4112a.db")
##D         
## End(Not run)




