###################################################
### chunk number 1: initialize
###################################################
options(width=40)


###################################################
### chunk number 2: attach
###################################################
require(rtracklayer)


###################################################
### chunk number 3: import
###################################################
track <- import(system.file("tests", "v1.gff", package =
                            "rtracklayer"))


###################################################
### chunk number 4: feature-data-accessors
###################################################
featChrom(track)
featStart(track)


###################################################
### chunk number 5: datavals-accessor
###################################################
dataVals(track)


###################################################
### chunk number 6: trackData
###################################################
df <- trackData(track)
plot(df$featMid, df$dataVals)


###################################################
### chunk number 7: browserSession eval=FALSE
###################################################
## session <- browserSession("ucsc")


###################################################
### chunk number 8: genomeBrowsers
###################################################
genomeBrowsers()


###################################################
### chunk number 9: layTrack eval=FALSE
###################################################
## session <- layTrack(session, track, name = "Demo Track")


###################################################
### chunk number 10: genomeSegment-track
###################################################
genomeSegment(track)


###################################################
### chunk number 11: take-subset
###################################################
subtrack <- track[1:2,] # get first two features


###################################################
### chunk number 12: view-subset eval=FALSE
###################################################
## view <- browserView(session, segment = genomeSegment(subtrack))


###################################################
### chunk number 13: browseGenome eval=FALSE
###################################################
## session <- browseGenome(tracks = track, browser = "ucsc", segment = 
##                         genomeSegment(subtrack))


###################################################
### chunk number 14: browseGenome-simple eval=FALSE
###################################################
## session <- browseGenome(track)


###################################################
### chunk number 15: get-track-names eval=FALSE
###################################################
## loaded_tracks <- tracks(session)


###################################################
### chunk number 16: get-track-data eval=FALSE
###################################################
## demo_track <- trackSet(session, name = "Demo Track")


###################################################
### chunk number 17: get-track-segment eval=FALSE
###################################################
## view_track <- trackSet(session, genomeSegment(view), "Demo Track")


###################################################
### chunk number 18: genomeSegment-view eval=FALSE
###################################################
## segment <- genomeSegment(view)


###################################################
### chunk number 19: tracks-view eval=FALSE
###################################################
## visible_tracks <- tracks(view)


###################################################
### chunk number 20: session-info
###################################################
  sessionInfo()


